package de.alexanderlindhorst.jca.ldap;

import org.apache.log4j.*;

import java.io.*;

import javax.naming.*;
import javax.naming.ldap.*;


/**
 * Represents the applications handle to the physical connection to the
 * underlying LDAP EIS
 * @author  $Author: lindhrst $
 * @version $Revision: 1.1.1.1 $
 */
public class LDAPConnection implements LdapContext, LDAPConnectorConstants {
    private static Logger logger = Logger.getLogger(LOG_CATEGORY);
    private LdapContext wrapped = null;
    private ManagedLDAPConnection associated = null;
    private boolean active = false;

    public LDAPConnection(LdapContext context, ManagedLDAPConnection parent) {
        wrapped = context;
        active = false;
        setAssociatedManagedConnection(parent);
        logger.info("New LDAPConnection instance created");
    }

    public void setAssociatedManagedConnection(ManagedLDAPConnection associated) {
        if (associated == null) {
            logger.warn("Association with null! Who dunnit? ");
            Thread.currentThread().dumpStack();
        }

        this.associated = associated;
    }

    public ManagedLDAPConnection getAssociatedManagedConnection() {
        return associated;
    }

    public Object addToEnvironment(String propName, Object propVal)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.addToEnvironment(propName, propVal);
    }

    public void bind(String name, Object obj) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.bind(name, obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.bind(name, obj);
    }

    public void bind(String name, Object obj,
        javax.naming.directory.Attributes attrs) throws NamingException {
        wrapped.bind(name, obj, attrs);
    }

    public void bind(Name name, Object obj,
        javax.naming.directory.Attributes attrs) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.bind(name, obj, attrs);
    }

    public void close() {
        //return this to the pool
        logger.debug(getClass() + " - Handle being closed: " + this);

        if (!active) {
            logger.debug("This handle has previously been closed, ignored");
        } else {
            associated.setHandleClosed(this);
        }

        logger.debug(getClass() + " - Handle has been closed");
    }

    public String composeName(String name, String prefix)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.composeName(name, prefix);
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.composeName(name, prefix);
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.createSubcontext(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.createSubcontext(name);
    }

    public javax.naming.directory.DirContext createSubcontext(Name name,
        javax.naming.directory.Attributes attrs) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.createSubcontext(name, attrs);
    }

    public javax.naming.directory.DirContext createSubcontext(String name,
        javax.naming.directory.Attributes attrs) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.createSubcontext(name, attrs);
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.destroySubcontext(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.destroySubcontext(name);
    }

    public ExtendedResponse extendedOperation(ExtendedRequest request)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.extendedOperation(request);
    }

    public javax.naming.directory.Attributes getAttributes(String name)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getAttributes(name);
    }

    public javax.naming.directory.Attributes getAttributes(Name name)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getAttributes(name);
    }

    public javax.naming.directory.Attributes getAttributes(Name name,
        String[] attrIds) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getAttributes(name, attrIds);
    }

    public javax.naming.directory.Attributes getAttributes(String name,
        String[] attrIds) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getAttributes(name, attrIds);
    }

    public Control[] getConnectControls() throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getConnectControls();
    }

    public java.util.Hashtable getEnvironment() throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getEnvironment();
    }

    public String getNameInNamespace() throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getNameInNamespace();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getNameParser(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getNameParser(name);
    }

    public Control[] getRequestControls() throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getRequestControls();
    }

    public Control[] getResponseControls() throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getResponseControls();
    }

    public javax.naming.directory.DirContext getSchema(String name)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getSchema(name);
    }

    public javax.naming.directory.DirContext getSchema(Name name)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getSchema(name);
    }

    public javax.naming.directory.DirContext getSchemaClassDefinition(Name name)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getSchemaClassDefinition(name);
    }

    public javax.naming.directory.DirContext getSchemaClassDefinition(
        String name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.getSchemaClassDefinition(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.list(name);
    }

    public NamingEnumeration listBindings(String name)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.listBindings(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.listBindings(name);
    }

    public Object lookup(String name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.lookup(name);
    }

    public Object lookup(Name name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.lookup(name);
    }

    public Object lookupLink(String name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.lookupLink(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.lookupLink(name);
    }

    public void modifyAttributes(Name name,
        javax.naming.directory.ModificationItem[] mods)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.modifyAttributes(name, mods);
    }

    public void modifyAttributes(String name,
        javax.naming.directory.ModificationItem[] mods)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.modifyAttributes(name, mods);
    }

    public void modifyAttributes(String name, int mod_op,
        javax.naming.directory.Attributes attrs) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.modifyAttributes(name, mod_op, attrs);
    }

    public void modifyAttributes(Name name, int mod_op,
        javax.naming.directory.Attributes attrs) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.modifyAttributes(name, mod_op, attrs);
    }

    public LdapContext newInstance(Control[] requestControls)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.newInstance(requestControls);
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.rebind(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.rebind(name, obj);
    }

    public void rebind(Name name, Object obj,
        javax.naming.directory.Attributes attrs) throws NamingException {
        wrapped.rebind(name, obj, attrs);
    }

    public void rebind(String name, Object obj,
        javax.naming.directory.Attributes attrs) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.rebind(name, obj, attrs);
    }

    public void reconnect(Control[] connCtls) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.reconnect(connCtls);
    }

    public Object removeFromEnvironment(String propName)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.removeFromEnvironment(propName);
    }

    public void rename(String oldName, String newName)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.rename(oldName, newName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.rename(oldName, newName);
    }

    public NamingEnumeration search(String name,
        javax.naming.directory.Attributes matchingAttributes)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.search(name, matchingAttributes);
    }

    public NamingEnumeration search(Name name,
        javax.naming.directory.Attributes matchingAttributes)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.search(name, matchingAttributes);
    }

    public NamingEnumeration search(Name name, String filter,
        javax.naming.directory.SearchControls cons) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.search(name, filter, cons);
    }

    public NamingEnumeration search(String name,
        javax.naming.directory.Attributes matchingAttributes,
        String[] attributesToReturn) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(Name name,
        javax.naming.directory.Attributes matchingAttributes,
        String[] attributesToReturn) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(String name, String filter,
        javax.naming.directory.SearchControls cons) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.search(name, filter, cons);
    }

    public NamingEnumeration search(Name name, String filterExpr,
        Object[] filterArgs, javax.naming.directory.SearchControls cons)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.search(name, filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(String name, String filterExpr,
        Object[] filterArgs, javax.naming.directory.SearchControls cons)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        return wrapped.search(name, filterExpr, filterArgs, cons);
    }

    public void setRequestControls(Control[] requestControls)
        throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.setRequestControls(requestControls);
    }

    public void unbind(String name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.unbind(name);
    }

    public void unbind(Name name) throws NamingException {
        if (!active) {
            throw new IllegalStateException("Not active.");
        }

        wrapped.unbind(name);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(final boolean active) {
        this.active = active;
    }
}
