package de.alexanderlindhorst.jca.ldap;

import org.apache.log4j.*;

import java.io.*;

import java.util.*;

import javax.naming.*;
import javax.naming.ldap.*;

import javax.resource.*;
import javax.resource.spi.*;


/**
 * ManagedConnectionFactory suitable to be used as LDAP Connector within JBoss.
 * @author  $Author: lindhrst $
 * @version $Revision: 1.2 $
 */
public class ManagedLDAPConnectionFactory implements ManagedConnectionFactory,
    LDAPConnectorConstants {
    private static Logger logger = Logger.getLogger(LOG_CATEGORY);
    private String host = null;
    private String user = null;
    private String password = null;
    private PrintWriter logWriter = null;

    public Object createConnectionFactory()
        throws javax.resource.ResourceException {
        throw new UnsupportedOperationException(
            "Not enough information to be supported.");
    }

    public Object createConnectionFactory(
        javax.resource.spi.ConnectionManager connectionManager)
        throws javax.resource.ResourceException {
        logger.info(getClass().toString() +
            " - ConnectionFactory creation requested");

        return new LDAPConnectionFactoryImpl(connectionManager, this, getInfo());
    }

    public javax.resource.spi.ManagedConnection createManagedConnection(
        javax.security.auth.Subject subject,
        javax.resource.spi.ConnectionRequestInfo connectionRequestInfo)
        throws javax.resource.ResourceException {
        logger.info(getClass().toString() +
            " - Subject information is ignored as an appropriate subject" +
            " will be provided by configuration");

        LDAPConnectionInfo settings = new LDAPConnectionInfo(getHost(),
                getUser(), getPassword());

        ManagedLDAPConnection connection = new ManagedLDAPConnection(settings);

        logger.debug(getClass().toString() + " - Got a Managed Connection: " +
            connection);

        return connection;
    }

    public java.io.PrintWriter getLogWriter()
        throws javax.resource.ResourceException {
        logger.info(
            "Log writer is request from this adapter instance, even though " +
            "we have our own logging settings ...");

        return logWriter; //we do our own logging via Log4J
    }

    public javax.resource.spi.ManagedConnection matchManagedConnections(
        java.util.Set set, javax.security.auth.Subject subject,
        javax.resource.spi.ConnectionRequestInfo connectionRequestInfo)
        throws javax.resource.ResourceException {
        logger.error(
            "FIXME: This method needs to be supported in order to allow for " +
            "connection pooling!");
        
        logger.debug("Criteria wanted:\n\tInfo: "+connectionRequestInfo);

        Iterator iterator = set.iterator();
        ManagedLDAPConnection current = null;
        LDAPConnectionInfo info = null;

        while (iterator.hasNext()) {
            current = (ManagedLDAPConnection) iterator.next();
            info = (LDAPConnectionInfo) current.getConnectionRequestInfo();
            logger.debug("Found: "+current+"; info: "+info);
            logger.debug("Current candidate being used? "+current.isBeingUsed());

            if ((info != null) && info.equals(connectionRequestInfo) &&
                    !(current.isBeingUsed())) {
                break;
            }

            //else delete the reference
            current = null;
        }

        return current;
    }

    public void setLogWriter(java.io.PrintWriter printWriter)
        throws javax.resource.ResourceException {
        this.logWriter = printWriter;
        logger.debug("setLogWriter called, remembered for reference; preferred" +
            logger.toString());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private LDAPConnectionInfo getInfo() {
        return new LDAPConnectionInfo(host, user, password);
    }

    //Required by spec
    public boolean equals(Object o) {
        if ((o == null) || !(o instanceof ManagedLDAPConnectionFactory)) {
            return false;
        }

        ManagedLDAPConnectionFactory f = (ManagedLDAPConnectionFactory) o;

        return f.getInfo().equals(getInfo());
    }

    public int hashCode() {
        return super.hashCode();
    }
}
